#ifndef _AVSDAPI_H_
#define _AVSDAPI_H_

#ifdef AVSDAPI_EXPORTS
#define AVSDAPI_API __declspec(dllexport)
#else
#define AVSDAPI_API __declspec(dllimport)
#endif

#define AVSD_FLOW_DTR_CONTROL        (0x01)
#define AVSD_FLOW_DTR_HANDSHAKE      (0x02)
#define AVSD_FLOW_CTS_HANDSHAKE      (0x08)
#define AVSD_FLOW_DSR_HANDSHAKE      (0x10)
#define AVSD_FLOW_DCD_HANDSHAKE      (0x20)
#define AVSD_FLOW_DSR_SENSITIVITY    (0x40)
#define AVSD_FLOW_RTS_HANDSHAKE      (0x80)


#define AVSD_SIGNAL_RTS		0x01
#define AVSD_SIGNAL_CTS		0x02
#define AVSD_SIGNAL_DTR		0x04
#define AVSD_SIGNAL_DSR		0x08
#define AVSD_SIGNAL_RI		0x10
#define AVSD_SIGNAL_CD		0x20

#define ERR_AVSD_TRIAL_EXPIRED			0x200000FF
#define ERR_AVSD_REBOOT_REQUIRED		0x20000100
#define ERR_AVSD_WRONG_PATH				0x20000101

//#define ERR_AVSD_

typedef struct
{
	DWORD dwBaudRate;
	BYTE ByteSize;
	BYTE Parity;
	BYTE StopBits;
	//
	CHAR cXonChar;
	CHAR cXoffChar;
	CHAR cErrorChar;
	CHAR cEofChar;
	CHAR cEvtChar;
	//
	WORD wXonLim;
	WORD wXoffLim;
	//
	BYTE FlowControl;
	DWORD FlowReplace;
} AVSD_PORT_SETTINGS, *PAVSD_PORT_SETTINGS;

AVSDAPI_API BOOL avsdPluginPort(DWORD dwPort, BOOL bOpenConfirmationNeeded);
AVSDAPI_API BOOL avsdUnplugPort(DWORD dwPort);
AVSDAPI_API BOOL avsdConnectPorts(DWORD dwPort1, DWORD dwPort2);
AVSDAPI_API BOOL avsdDisconnectPorts(DWORD dwPort1, DWORD dwPort2);
AVSDAPI_API BOOL avsdGetConnectedPort(DWORD dwPort, PDWORD pdwConnectedPort);
AVSDAPI_API BOOL avsdIsPortPluggedIn(DWORD dwPort,PBOOL pbPlugged);

AVSDAPI_API BOOL avsdWriteCharToPortBuffer(DWORD dwPort, CHAR Char);
AVSDAPI_API BOOL avsdReadCharFromPortBuffer(DWORD dwPort, PCHAR pChar);
AVSDAPI_API BOOL avsdWriteToPortBuffer(DWORD dwPort, PBYTE pBuffer, DWORD dwSize, PDWORD pdwWritten);
AVSDAPI_API BOOL avsdReadFromPortBuffer(DWORD dwPort, PBYTE pBuffer, DWORD dwSize, PDWORD pdwRead);

AVSDAPI_API BOOL avsdGetControlSignals(DWORD dwPort, PDWORD pdwSignals);
AVSDAPI_API BOOL avsdSetControlSignals(DWORD dwPort, DWORD dwSignals);
AVSDAPI_API BOOL avsdGetSettings(DWORD dwPort, PAVSD_PORT_SETTINGS pConfig);

AVSDAPI_API BOOL avsdIsPortOpened(DWORD dwPort, PBOOL pbOpened);
AVSDAPI_API BOOL avsdConfirmPortOpening(DWORD dwPort, DWORD dwOpenResult);
AVSDAPI_API BOOL avsdGetNumBytesInBuffer(DWORD dwPort, PDWORD pdwBytes);

AVSDAPI_API HANDLE avsdGetDataEvent(DWORD dwPort);
AVSDAPI_API HANDLE avsdGetSettingsEvent(DWORD dwPort);
AVSDAPI_API HANDLE avsdGetFlowEvent(DWORD dwPort);
AVSDAPI_API HANDLE avsdGetOpenCloseEvent(DWORD dwPort);

AVSDAPI_API BOOL avsdInstallDrivers(CHAR* szPathToDrivers);
AVSDAPI_API BOOL avsdUninstallDrivers();

#endif // #ifndef _AVSDAPI_H_